#include "soundsystem.h"


SoundSystem::SoundSystem(void)
{
	name_e[0] = "collect.ogg";
	name_e[1] = "jump.ogg";
	name_e[2] = "jump2.ogg";
}

SoundSystem::~SoundSystem(void)
{

}

void SoundSystem::init() {

		int audio_rate = 44100;
		Uint16 audio_format = AUDIO_S16;	// byteorder
		int audio_channels = 2;
		int audio_buffers = 4096;
		if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers)==-1) {
		} else {
			Mix_QuerySpec(&audio_rate, &audio_format, &audio_channels);
		}

		Mix_AllocateChannels(16);

		string path = "./data/";
		string filename = "";

		int i=0;
		for(i=0; i<NUM_EFF; i++) {
			
			filename = path + name_e[i];
			effect[i]=Mix_LoadWAV(filename.c_str());
			if(!effect[i]) {
				printf("  Mix_LoadWAV: %s\n", Mix_GetError());
			} 

		}

}

void SoundSystem::close() {
		
	int i=0;
		for(i=0; i<NUM_EFF; i++)
			Mix_FreeChunk(this->effect[i]);

		Mix_AllocateChannels(0);

		Mix_CloseAudio();
}

void SoundSystem::play(int i) {

	if(i>=0 && i<NUM_EFF)
	 if(Mix_PlayChannel(-1, effect[i], 0)==-1) {
		//printf("Mix_PlayChannel: %s\n",Mix_GetError());	
	 }
}
