#ifndef _RGL_H_
#define _RGL_H_

/**
 * Vector+Rect+SDL/OpenGL Init crap
 */


#ifndef LINUX
#include "SDL.h"
#include "SDL_opengl.h"
#else
#include <SDL/SDL.h>
#endif

#include <stdlib.h> // for exit(1)
#include <string.h>
#include "math.h"
#include <string>

extern int OPENGL_WIDTH;
extern int OPENGL_HEIGHT;

//Ortho mode
void perspective2D(float width, float height);
void perspective3D();
bool RFitsScreen(int x, int y, int w, int h);

void setup_opengl(int width, int height);
void setup_sdl(const char* title, int width, int height, int bpp, bool fullscreen);
void setup_window(const char* title, int width, int height, int bpp, bool fullscreen);

void font_init();
void print(const char *str, int x, int y);
void printSmall(const char *str, int x, int y);
void printCenteredX(const char *str, int x, int y);

class Vector
{
public:
	Vector() { x=0; y=0; };
	Vector(float xx, float yy) { x=xx; y=yy; };
	Vector(Vector &e) { x= e.x; y=e.y; };
	~Vector() {};

	float angleBetween(Vector b) { return (float)atan2( y-b.y , x-b.x ); }
	float length() { return sqrt(x*x+y*y); }
	
	void normalize() { float len = length(); if(len==0.0f) return; x /= len; y /= len; }
	float dotProduct(Vector &v) { return x*v.x + y*v.y; };
	
	Vector operator + (Vector const &v) { return Vector( x+v.x, y+v.y); };
	Vector operator - (Vector const &v) { return Vector( x-v.x, y-v.y); };
	Vector operator += (Vector const &v) { x+=v.x; y+=v.y; };
	Vector operator -= (Vector const &v) { x-=v.x; y-=v.y; };
	
	// Slow shit - should be optimized on int cases. but 48h:)
	Vector operator * (float v) { return Vector( x*v, y*v); };
	Vector operator / (float v) { if(v==0.0f) return Vector(0,0); return Vector( x/v, y/v); };
	Vector operator *= (float v) { x*=v; y*=v; };
	Vector operator /= (float v) { if(v==0.0f) return Vector(0,0); x/=v; y/=v; };

	// next time fabs(val)<min
	bool operator == (Vector const &v) { if( v.x == x && v.y == y ) return true; else return false; }
	void operator = (Vector const &v) { x=v.x; y=v.y; }

	float x,y;
};


class RRect {

	public:
		RRect() {
			this->x=0;
			this->y=0;
			this->w=100;
			this->h=100;
		}
		RRect(int gx,int gy,int gw,int gh) { 
			this->x=gx;
			this->y=gy;
			this->w=gw;
			this->h=gh;
		}
		void setX(int gx) { this->x=gx; }
		void setY(int gy) { this->y=gy; }
		void setW(int gw) { this->w=gw; }
		void setH(int gh) { this->h=gh; }

		int getX() { return this->x; }
		int getY() { return this->y; }
		int getW() { return this->w; }
		int getH() { return this->h; }

		bool isIn(int xx, int yy) {
			int right = x+w;
			int bottom = y+h;
			int left = x;
			int top = y;

			if(right<left) {
				int tmp=right;
				right=left;
				left=tmp;
			}
			if(bottom<top) {
				int tmp=bottom;
				bottom=top;
				top=tmp;
			}

			if(xx>right || xx<left || yy>bottom || yy<top)
				return false;
			return true;	
		}

	private:
		int x, y, w, h;
};

#endif
 
