#include "rgl.h"

void perspective2D(float width, float height)
{
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();	
	glOrtho(0, width, height, 0,-1,1);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix(); 
	glLoadIdentity();
}
void perspective3D()
{
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}

extern RRect screenArea;

bool RFitsScreen(int x, int y, int w, int h) {
	if(screenArea.isIn(x,	y)  ==false &&
	   screenArea.isIn(x+w,	y)  ==false &&
	   screenArea.isIn(x,	y+h)==false &&
	   screenArea.isIn(x+w,	y+h)==false)
	   return false;
	return true;
}

void setup_sdl(const char* title, int width, int height, int bpp, bool fullscreen)
{


    if ( SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO) < 0 ) {
        printf("Couldn't initialize SDL: %s\n", SDL_GetError());
        exit(1);
    }

    atexit(SDL_Quit);

	// Icon
	SDL_Surface *icon;
	icon = SDL_LoadBMP("data/icon.bmp");
	if(icon) SDL_WM_SetIcon(icon, NULL);
	else printf("  Failed to load icon.bmp\n");
	SDL_FreeSurface(icon);

	setup_window(title,width,height,bpp,fullscreen);
}
void setup_window(const char* title, int width, int height, int bpp, bool fullscreen) {

    const SDL_VideoInfo* video;

    video = SDL_GetVideoInfo( );

    if( !video ) {
        printf("Couldn't get video information: %s\n", SDL_GetError());
        exit(1);
    }

    // Set the minimum requirements for the OpenGL window 
    SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 8 );
    SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 8 );
    SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 8 );

	SDL_GL_SetAttribute( SDL_GL_ALPHA_SIZE , 8);
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );

    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
				
	SDL_WM_SetCaption(title, "icon");
	
	int flags = 0;
	flags = SDL_OPENGL;
	if(fullscreen) 
		flags = SDL_OPENGL | SDL_FULLSCREEN;

	// no vsync 
	SDL_GL_SetAttribute(SDL_GL_SWAP_CONTROL, 0);
	
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

	if( SDL_SetVideoMode( width, height, video->vfmt->BitsPerPixel, flags) == NULL ) {
		printf("Couldn't set video mode: %s\n", SDL_GetError());
	}

}

void setup_opengl(int width, int height)
{
    float aspect = (float)width/ (float)height;

    glViewport(0,0, width*1.0f, height*1.0f);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    
	// fov, aspect, nearplane, farplane
    gluPerspective(60.0f, aspect, 10.0f, 1500.0f);

    glMatrixMode(GL_MODELVIEW);

    glClearColor(1.0f, 1.0f, 1.0f, 0);
    
	glEnable(GL_TEXTURE_2D);

	glDepthFunc(GL_ALWAYS);

    glDisable(GL_CULL_FACE);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
	glEnable(GL_LINE_SMOOTH);

	glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
	glEnable(GL_POINT_SMOOTH);
}

// --------

int fontBase;
int fontBase_;

void font_init()
{
  HFONT fontObject;
  fontObject  = CreateFont(24, 10, 0, 0,
                           FW_SEMIBOLD, // weight
						   false, // italic
						   false, // underline
						   false, // strike
                           ANSI_CHARSET,
						   OUT_TT_PRECIS,
                           CLIP_DEFAULT_PRECIS, 
						   ANTIALIASED_QUALITY,
                           FF_DONTCARE|DEFAULT_PITCH,
                           "Tahoma MS");
  
  fontBase = glGenLists(96);
  SelectObject(wglGetCurrentDC(), fontObject);
  wglUseFontBitmaps(wglGetCurrentDC(), 32, 96, fontBase);
  
  DeleteObject(fontObject);

  fontObject  = CreateFont(12, 6, 0, 0,
                           FW_NORMAL, // weight
						   false, // italic
						   false, // underline
						   false, // strike
                           ANSI_CHARSET,
						   OUT_TT_PRECIS,
                           CLIP_DEFAULT_PRECIS, 
						   ANTIALIASED_QUALITY,
                           FF_DONTCARE|DEFAULT_PITCH,
                           "Tahoma MS");
  
  fontBase_ = glGenLists(96);
  SelectObject(wglGetCurrentDC(), fontObject);
  wglUseFontBitmaps(wglGetCurrentDC(), 32, 96, fontBase_);
  
  DeleteObject(fontObject);

}

// Draw empty & get movement of raster - hacky as hell.
// But you can't get the spacing easily anyway... 
// If you have better way email me :)
int getFontW(const char *str)
{
    glColorMask(false, false, false, false);
    glRasterPos2i(0,0);
    glPushAttrib(GL_LIST_BIT);
		glListBase(fontBase - 32);
		glCallLists(strlen(str), GL_UNSIGNED_BYTE, str);
    glPopAttrib();
	int rasterPosition[4];
    glGetIntegerv(GL_CURRENT_RASTER_POSITION, rasterPosition);
    glColorMask(true, true, true, true);

	return rasterPosition[0];
}

void print(const char *str, int x, int y) 
{
  glRasterPos2i(x, y);
  glPushAttrib(GL_LIST_BIT);
	glListBase(fontBase - 32);
	glCallLists(int(strlen(str)), GL_UNSIGNED_BYTE, str);
  glPopAttrib();
}

void printCenteredX(const char *str, int x, int y)
{
	int w_ = getFontW(str);
	print(str, x - w_/2, y);
}


void printSmall(const char *str, int x, int y) 
{
  glRasterPos2i(x, y);
  glPushAttrib(GL_LIST_BIT);
	glListBase(fontBase_ - 32);
	glCallLists(int(strlen(str)), GL_UNSIGNED_BYTE, str);
  glPopAttrib();
}