#ifndef _PLAYSTATE_H_
#define _PLAYSTATE_H_

/**
 * Menu + game + stats stuff
 */

#include <time.h>
#include "rgl.h"
#include "soundsystem.h"

// -----------------------------
extern Uint32 gametime;

extern RRect screenArea;
extern bool done;
extern bool keyEscape;
extern bool keySpace;
extern bool keyUp;
extern bool keyDown;
extern bool keyLeft;
extern bool keyRight;
extern bool keyR;
extern bool keyEnter;
extern bool mouseLeft;
extern bool mouseRight;
extern bool done;

extern SoundSystem *sound;

extern int nextState;
extern void updateState();
extern void changeState(int toId);

// ------------
// Collisioeffu
// ------------
const int EFFU_COUNT = 30;
class Effu
{
public:
	Effu()
	{
		pos = new Vector[EFFU_COUNT];
		spd = new Vector[EFFU_COUNT];
	};
	~Effu() {delete [] pos; delete [] spd;};
	Vector *pos;
	Vector *spd;
	float timeLeft;
	void start(Vector p, Vector n)
	{

		n.normalize();

		Vector v[10] =
		{
			Vector(rand()%10-5, rand()%10-5)*0.2f,
			Vector(rand()%10-5, rand()%10-5)*0.2f,
			Vector(rand()%10-5, rand()%10-5)*0.2f,
			Vector(rand()%10-5, rand()%10-5)*0.2f,
			Vector(rand()%10-5, rand()%10-5)*0.2f,
			Vector(rand()%10-5, rand()%10-5)*0.2f,
			Vector(rand()%10-5, rand()%10-5)*0.2f,
			Vector(rand()%10-5, rand()%10-5)*0.2f,
			Vector(rand()%10-5, rand()%10-5)*0.2f,
			Vector(rand()%10-5, rand()%10-5)*0.2f,
		};

		timeLeft = 300;
		for(int i=0; i<EFFU_COUNT; i++)
		{
			pos[i] = p;
			spd[i] = n*(3 + i%5)*0.0172f;//*0.0051f;
			spd[i] += v[i%10]*0.0304f;
		}
	}
	void update(int delta)
	{
		if(timeLeft>=0)
			timeLeft-=delta;
		
		for(int i=0; i<EFFU_COUNT; i++)
			pos[i]+=spd[i]*delta;
	};
	void draw();
};

// ------------
// Play state
// ------------

const int CAMERA_STATE_STILL = 0;
const int CAMERA_STATE_LERP = 1;

class Camera
{
public:
	Camera();
	~Camera() {};
	int state;
	Vector target;
	Vector start;
	Vector pos;
	float camtime;
	float goalTime;
	void setPosition(Vector v);
	void startDrive(Vector v, float time);
	void update(int delta);
};

// ------------

class Player
{
public:
	Player();
	~Player();
	void draw();
	void update(int delta);
	Vector pos;
	Vector spd;
	float radius;
	float anglespeed;
	float jumpTime;
	bool jumpOnNextHit;
};

// ------------

const int MAP_POINTS = 250;
class Map
{
public:
	Map();
	~Map();
	int lastAdded;
	Vector *points;
	bool addPoint(Vector v);
	void draw();
	Vector getLastAddedPos();

	float lastGrowValue;
	void drawGrowIdentifier();
	Vector getGrowIdentifier(bool store=false);

	Vector collisionPlatform;
	Vector collisionNormal;
	bool circleCollision(Vector origin, float radius);
};

// -----------------------------

const int MAX_PICKUPS = 50;

const int PICKUP_EMPTY_ID = 0;
const int PICKUP_TRIANGLE = 1;
class Pickup
{
public:
	Pickup() { id=PICKUP_EMPTY_ID; deathAnimationTime = 1000000;};
	~Pickup() {};

	int id;
	Vector pos;
	Vector size;

	int deathAnimationTime;

	bool collideWithPlayer();

	int storedId;//original id.
};

class Pickups
{
public:
	Pickups();
	~Pickups();

	Pickup *list;

	bool addPickup(Pickup p);
	void destroyPickup(int i);
	void update(int delta);
	void draw();
	void resetToOriginal();

	int pickupsLeft;
	int pickupsStart;
};

// -----------------------------

void initGame();
void freeGame();
const int RESET_ALL = 0;
const int RESET_PLAY_MODE = 1;
const int RESET_LEVEL_MODE = 2;
void resetGame(int resetType=0);

// -----------------------------

void drawGameState();
void updateGameState(int delta);

// ------------



// ------------
// Menustate
// ------------

const int MENU_ITEMS = 10;

void initMenu();
void drawMenu(float alpha);
void handleMouse(int x, int y);
void updateMenu(int delta);

class MenuItem
{
public:
	MenuItem() {};
	~MenuItem() {};
	RRect pos;
	int trianglesAvailable;
	int trianglesCollected;
	int deactivateTime;
};


#endif