#include "playstate.h"

// This file is a big fucking mess. :)
// should have split into multiple files	

// -----------------------------
// Game mode data
// -----------------------------

const float ANGLESPDLIMIT = 0.01f;

const int GAME_MODE_STATE_HELP  = -1;
const int GAME_MODE_STATE_CREATE= 0;
const int GAME_MODE_STATE_PLAY	= 1;
const int GAME_MODE_STATE_SCORE	= 2;
const int GAME_MODE_STATES		= 3;
int gameModeState;

void endGame(); // call this when moving from gamestate => menu
void saveScore();

Effu *effu;

// -----------------------------

bool generateRandomLevel;

// -----------------------------

// Menu stuff
MenuItem *menuItems;
int activeItem;
int fadeTime;

// -----------------------------

// Game stuff
Map *map;
Player *player;
Camera *camera;
Pickups *pup;

// ----------------------------------

// Used to store edge hits on collisionnormal.
const float EDGE = -10000;

const int NO_COL = -1;
const int MIDDLE = 0;
const int START = 1;
const int END = 2;
float distance_to_line(Vector start, Vector end, Vector point, int *where)
{

	Vector v1 = point - start;
	Vector v2 = end - start;

	float len = v2.length();
	v2.x = v2.x/len;
	v2.y = v2.y/len;

	float dp = v1.dotProduct(v2);

	if(dp<=0)
	{
		*where = START;
		return Vector(point - start).length();
	}
	else if(dp>=len)
	{
		*where = END;
		return Vector(point - end).length();
	}
	else
	{
		*where = MIDDLE;
		Vector v3 = v2 * dp;
		Vector vt = start + v3;
		return Vector(point-vt).length();
	}
}



// -----------------------------

Camera::Camera() 
{
	pos = Vector(-400, -300); 
	state = CAMERA_STATE_STILL;
}

void Camera::update(int delta)
{
	switch(state)
	{
	case CAMERA_STATE_STILL:
		pos = target;
		break;
	case CAMERA_STATE_LERP:
	{
		camtime -= delta;
		if(camtime<=0)
		{
			state = CAMERA_STATE_STILL; 
			camtime = 0.0f;
		}
		Vector dir = target - start;
		float len = dir.length();
		dir.normalize();
		pos = start + dir*len*powf(sinf((1-camtime/goalTime)*1.570f),2);
	} break;

	}
}

void Camera::startDrive(Vector v, float time)
{
	state = CAMERA_STATE_LERP;
	target = v;
	start = pos;
	camtime = time;
	goalTime = time;
}

void Camera::setPosition(Vector v)
{
	state = CAMERA_STATE_STILL;
	target = v;
}

// -----------------------------

Player::Player()
{
	pos = Vector(0,-100);
	spd = Vector();
	radius = 15.0f;
	jumpOnNextHit=false;
}

Player::~Player()
{
}

void Player::update(int delta)
{
	
	if(keyUp || keySpace)
	{
		jumpOnNextHit = true;
		keyUp = keySpace = false;
	}

	if(jumpTime>=0)
		jumpTime -= delta;

	spd += Vector(0, 0.0008f) * delta;//gravity
	
	Vector newPos = pos + spd * delta;

		
	int iteration = 1;
	float leng = Vector(pos - newPos).length();
	// check if need more than 1 iteration
	if(leng > radius)
	{
		// Calc iterations
		iteration = leng/(radius)+1;
	}

	Vector del_ = (newPos - pos)/iteration;

	bool COLLISION = false;

	Vector posToTest = pos;
	int iter=0;
	for(iter=0; iter<iteration; iter++)
	{
			
		posToTest+del_;
	

		bool collided = map->circleCollision(newPos, radius);
		if(collided)
		{

			COLLISION=true;

			if(map->collisionNormal==Vector(EDGE, EDGE))
			{ // Special case
				this->spd *= -1;
			} 
			else
			{ // Normal case
				
				const float friction = 0.99f;
				const float bounce = 0.799f;
				
				Vector normal   = map->collisionNormal;
				Vector platform = Vector(-normal.y, normal.x);
				
				float dp1 = spd.dotProduct(platform);
				Vector proj1 = platform*dp1;
				Vector frc = proj1*friction;

				float dp2 = spd.dotProduct(normal);
				Vector proj2 = normal*dp2*-1;
				Vector bnc = proj2*bounce;
				
				spd = frc + bnc;

				if(jumpOnNextHit && normal.y<0 && fabs(normal.y)>0.3f)
				{
					spd += normal * 0.35f;
					if(spd.length()>0.1625f)
					{	
						sound->play(2);
						effu->start(posToTest, spd*-1);
						jumpTime = 150;
					}
				}
				else 
				{
					if(jumpTime<=0)
					{
						if(spd.length()>0.1625f)
						{
							sound->play(1);
							effu->start(posToTest, spd*-1);
							jumpTime = 150;
						}
						
					}
				}
				jumpOnNextHit=false;
			}

		}
	}
		

	if(COLLISION==false)
	{
		pos = newPos;
	}
	
}

void Player::draw()
{
	
	float jumpgraffamodi = 1.0f;
	if(jumpOnNextHit)
	{
		jumpgraffamodi = 0.85f - sinf(gametime*0.020f)*0.15f;
		glColor3f(jumpgraffamodi*jumpgraffamodi*jumpgraffamodi*jumpgraffamodi,0,0);
	} 
	else 
	{	
			glColor3f(0.3f,0.3f,0.3f);
	}
	//glBegin(GL_LINE_STRIP);
	glBegin(GL_TRIANGLE_FAN);
	for(float f=0.0f; f<6.2831f; f+=0.12f)
		glVertex2f(	pos.x + sinf(f) * this->radius*0.75f*jumpgraffamodi - camera->pos.x, 
					pos.y + cosf(f) * this->radius*0.75f*jumpgraffamodi - camera->pos.y);

		glVertex2f(	pos.x + sinf(0) * this->radius*0.75f*jumpgraffamodi - camera->pos.x, 
					pos.y + cosf(0) * this->radius*0.75f*jumpgraffamodi - camera->pos.y);
	glEnd();


	float mod = 1.0f;
	float mod2 = 1.0f;
	if(jumpTime>0)
	{
		mod = 1 + (jumpTime / 150.0f)*0.35f;
		mod2 = 1 + (jumpTime / 150.0f)*0.35f;
	}

	glColor4f(1-mod,1-mod2,0, 0.3f);
	glBegin(GL_LINE_STRIP);
	for(f=0.0f; f<6.2831f; f+=0.25f)
		glVertex2f(	pos.x + sinf(f) * this->radius*mod2 - camera->pos.x, 
					pos.y + cosf(f) * this->radius*mod  - camera->pos.y);

		glVertex2f(	pos.x + sinf(0) * this->radius*mod2 - camera->pos.x, 
					pos.y + cosf(0) * this->radius*mod  - camera->pos.y);
	glEnd();
}

// -----------------------------

Map::Map()
{
	points = new Vector[MAP_POINTS];
	lastAdded = -1;
	addPoint(Vector(-40, -700));
	addPoint(Vector(-40, 00));
	addPoint(Vector(100,40));

	collisionNormal = Vector();

	lastGrowValue = 1.57079f; // alkaa oikealta.
}

Map::~Map()
{
	delete [] points;
}

void Map::draw()
{

	Vector cp = camera->pos;
	
	// shake! 
	//if(player->jumpOnNextHit==1)
	//	cp += Vector(rand()%5-2,rand()%5-2)*player->jumpTime*0.15f;

	int i;
	
	Vector a,b;
	

	for(i=1; i<=lastAdded; i++)
	{
		a = points[i-1] - cp;
		b = points[i]   - cp;

		if(a.x > b.x) 
		{
			Vector t = a;
			a=b;
			b=t;
		}

		// Get rid of lines that are not visible
		if(screenArea.getW() < a.x) continue;
		if(0		  	     > b.x) continue;
		
		glColor4f(0.96f,0,0.4f,0.35f);
		glBegin(GL_LINES);
		glVertex2f(	a.x,a.y);
		glVertex2f(	b.x,b.y);
		glColor4f(0.96f,0,0.4f,0.15f);
		glVertex2f(	a.x,a.y+3);
		glVertex2f(	b.x,b.y+3);
		glVertex2f(	a.x,a.y-3);
		glVertex2f(	b.x,b.y-3);
		glVertex2f(	a.x+3,a.y);
		glVertex2f(	b.x+3,b.y);
		glVertex2f(	a.x-3,a.y);
		glVertex2f(	b.x-3,b.y);
		glEnd();

		glPointSize(2);
		glColor3f(0.66f,0,0.24f);
		glBegin(GL_POINTS);
		glVertex2f(	a.x,a.y);
		glVertex2f(	b.x,b.y);
		glEnd();
		glPointSize(1);
	}
	

};

Vector Map::getGrowIdentifier(bool store)
{
	float d = sinf(gametime*0.0075f)*0.75f;
	float spd = lastGrowValue + d;

	float sin = sinf(spd);
	float cos = cosf(spd);

	const float length = 75;

	float offx = sin*length;
	float offy = cos*length;

	if(store) 
	{
		lastGrowValue = spd;
	}

	return Vector(
				points[lastAdded].x + offx, 
				points[lastAdded].y + offy
			);
}

void Map::drawGrowIdentifier()
{
	Vector grow = getGrowIdentifier();
	Vector a = Vector(points[lastAdded].x - camera->pos.x, points[lastAdded].y - camera->pos.y);
	Vector b = Vector(grow.x - camera->pos.x, grow.y - camera->pos.y);

	glBegin(GL_LINES);
		
	// Fake glow

		glColor4f(0.96f,0,0.4f,0.35f);
		glVertex2f(a.x,a.y);
		glColor4f(0,0,1,0.35f);
		glVertex2f(b.x,b.y);

		glColor4f(0.96f,0,0.4f,0.15f);
		glVertex2f(a.x,a.y+3);
		glColor4f(0,0,1,0.35f);
		glVertex2f(b.x,b.y);

		glColor4f(0.96f,0,0.4f,0.15f);
		glVertex2f(a.x,a.y-3);
		glColor4f(0,0,1,0.35f);
		glVertex2f(b.x,b.y);

		glColor4f(0.96f,0,0.4f,0.15f);
		glVertex2f(a.x+3,a.y);
		glColor4f(0,0,1,0.35f);
		glVertex2f(b.x,b.y);

		glColor4f(0.96f,0,0.4f,0.15f);
		glVertex2f(a.x-3,a.y);
		glColor4f(0,0,1,0.35f);
		glVertex2f(b.x,b.y);

	glEnd();
}

bool Map::addPoint(Vector v)
{
	if(lastAdded + 1 >= MAP_POINTS)
		return false;

	lastAdded++;
	points[lastAdded] = v;


	return true;
};

Vector Map::getLastAddedPos()
{
	if(lastAdded<0) return Vector();
	
	return points[lastAdded];
}


bool Map::circleCollision(Vector origin, float radius)
{
	// Reset collision data
	collisionNormal = Vector();
	
	// Bounding box for circle [double sized]
	float x = origin.x - radius*2;
	float y = origin.y - radius*2;
	float w = radius * 4;
	float h = radius * 4;

	Vector a;
	Vector b;
	for(int i=1; i<=lastAdded; i++)
	{
		
			a = points[i-1];
			b = points[i];

			if(a.x > b.x) 
			{
				Vector t = a;
				a=b;
				b=t;
			}

			// Get rid of lines that can't collide 
			if(x+w < a.x) continue;
			if(x   > b.x) continue;


			// This can contain a collision
			int collision = -1;
			float dist = distance_to_line(a, b, origin, &collision);
			if(dist < radius)
			{//collided

				if(collision==MIDDLE)
				{
					Vector line = b - a;
					line.normalize();
					collisionNormal = Vector(line.y, -line.x);
				} 
				else 
				{

/*
					Vector line = b - a;
					line.normalize();
					collisionNormal = Vector(line.y, -line.x);

//	
/**/
					Vector d1 = points[i] - origin;
					Vector d2 = points[i+1] - origin;

					if(d1.length() > d2.length())
						collisionNormal = origin - points[i+1];
					else 
						collisionNormal = origin - points[i];

					collisionNormal.normalize();
// **/
				}
				return true;

			} 
			else 
			{
				continue;
			}
	}

	return false;
}

// ---------------------------------------------
bool Pickup::collideWithPlayer()
{
	
	if(deathAnimationTime < 1000) return false;

	return !(pos.x + size.x < player->pos.x || 
			 pos.x - size.x > player->pos.x + player->radius || 
			 pos.y + size.y < player->pos.y || 
			 pos.y - size.y > player->pos.y + player->radius		
		);
}
// ---------------------------------------------

Pickups::Pickups()
{
	list = new Pickup[MAX_PICKUPS];
	pickupsStart = 0;
	pickupsLeft = 0;

	// Generation mechanics
	if(generateRandomLevel)
	{
		srand(time(0));
		for(int i=0; i<5+rand()%10; i++)
		{
			int x = (i+1)*(350+rand()%200);
			int y = -100 + i*20 + rand()%1200;
			Pickup p;
			p.deathAnimationTime = 99999999;
			p.id = p.storedId = PICKUP_TRIANGLE;
			p.pos.x = x;
			p.pos.y = y;
			p.size.x = p.size.y = 55;
			this->addPickup(p);
		}
	} 
	else
	{
		// level generation
		const int count = menuItems[activeItem].trianglesAvailable;
		srand(activeItem+44);
		for(int i=0; i<count; i++)
		{
			int x = (i+1)*(350+rand()%200);
			int y = -100 + i*70 + rand()%1200;
			Pickup p;
			p.deathAnimationTime = 99999999;
			p.id = p.storedId = PICKUP_TRIANGLE;
			p.pos.x = x;
			p.pos.y = y;
			p.size.x = p.size.y = 55;
			this->addPickup(p);
		}
	}
	
	generateRandomLevel = false;
}

Pickups::~Pickups()
{
	delete [] list;
}

void Pickups::update(int delta)
{
	Pickup p;
	
	int count = 0;

	int i;
	for(i=0; i<MAX_PICKUPS; i++)
	{
		p = list[i];
		
		if(p.id==PICKUP_EMPTY_ID) 
			continue;

		if(list[i].deathAnimationTime < 1000)
			list[i].deathAnimationTime -= delta;

		switch(p.id)
		{
		case 0:
			break;
		case PICKUP_TRIANGLE:

			if(p.deathAnimationTime < 0) 
			{
				list[i].id = PICKUP_EMPTY_ID;
			}
			
			if(p.collideWithPlayer())
			{
				destroyPickup(i);
			}
			
			count++;

			break;
		default:
			break;
		}
	}
	
	pickupsLeft=count;
}

void Pickups::draw()
{
	Pickup p;
	
	int i;
	for(i=0; i<MAX_PICKUPS; i++)
	{
		p = list[i];
		
		if(p.id==PICKUP_EMPTY_ID) 
			continue;

		if(!RFitsScreen(p.pos.x - p.size.x - camera->pos.x, p.pos.y - p.size.y - camera->pos.y, p.size.x, p.size.y)) 
			continue;

		float t = gametime*0.008f;

		switch(p.id)
		{
		case PICKUP_TRIANGLE:
		{			
			
			float a = 0.0f;
			float scale = 1.0f;
			if(p.deathAnimationTime < 1000)
				a = (1 - (p.deathAnimationTime / 300.0f));
			
			scale += a*3.0f;

			Vector aa = Vector(p.pos.x + p.size.x * 0.6f * scale * sinf(t+0*2.094395f+i) - camera->pos.x, 
					   p.pos.y + p.size.x * 0.6f * scale * cosf(t+0*2.094395f+i) - camera->pos.y);
			Vector bb = Vector(p.pos.x + p.size.x * 0.6f * scale * sinf(t+1*2.094395f+i) - camera->pos.x, 
					   p.pos.y + p.size.x * 0.6f * scale * cosf(t+1*2.094395f+i) - camera->pos.y);
			Vector cc = Vector(p.pos.x + p.size.x * 0.6f * scale * sinf(t+2*2.094395f+i) - camera->pos.x, 
					   p.pos.y + p.size.x * 0.6f * scale * cosf(t+2*2.094395f+i) - camera->pos.y);


			glColor4f(1-a*0.5f,1-a*0.5f,1-a*0.5f, 1-a);
			glBegin(GL_TRIANGLES);
				glVertex2f(aa.x, aa.y);
				glVertex2f(bb.x, bb.y);
				glVertex2f(cc.x, cc.y);			
			glEnd();


			glColor4f(0,0,0, 1-a);
			glBegin(GL_LINE_STRIP);
				glVertex2f(aa.x, aa.y);
				glVertex2f(bb.x, bb.y);
				glVertex2f(cc.x, cc.y);
				glVertex2f(aa.x, aa.y);
			glEnd();
			
		} break;
		default:
			break;
		}
	}
}

bool Pickups::addPickup(Pickup p)
{
	int i;
	for(i=0; i<MAX_PICKUPS; i++)
	{
		if(list[i].id!=PICKUP_EMPTY_ID)  
		{
			continue;
		}
		else
		{
			if(p.id == PICKUP_TRIANGLE) 
			{	
				pickupsStart++;
				this->pickupsLeft=pickupsStart;
			}
			list[i] = p;
			return true;
		}
	}
	return false;
}

void Pickups::destroyPickup(int i)
{
	list[i].deathAnimationTime = 300;
	sound->play(0);
}

void Pickups::resetToOriginal()
{
	int i;
	for(i=0; i<MAX_PICKUPS; i++)
	{
		list[i].id = list[i].storedId;
		list[i].deathAnimationTime = 9999999;
	}
}

// ---------------------------------------------


void drawHud()
{
	
	Vector position = player->pos;
	if(gameModeState==GAME_MODE_STATE_CREATE)
	{
		position = map->getLastAddedPos();
	}

	int i;
	// Identifiers
	for(i=0; i<MAX_PICKUPS; i++)
	{
		if(pup->list[i].id==PICKUP_TRIANGLE)  
		{
		
			Vector dir = pup->list[i].pos/*+(pup->list[i].size*0.5f)*/ - position;
			float len = dir.length();
			dir.normalize();
			Vector to;
			//to = position + dir * 500 * ((len > 4000 ? 1 : len/4000.0f));
			const float lerp =((len > 800 ? 1 : len/800.0f));
			to = position + dir * 800 * lerp;
			to -= camera->pos;
			if(to.x<0)to.x=0;
			if(to.x>800)to.x=800;
			if(to.y<0)to.y=0;
			if(to.y>600)to.y=600;
		
			// Arrows
			Vector to2 = to - dir*(20+(1-lerp)*25.0f);
			Vector n = Vector(dir.y, -dir.x);
			Vector k = to-dir*10;
			k+=n*7;


			glBegin(GL_LINES);

				
				glColor3f(1,0,0);
				glVertex2f(to.x,   to.y);
				glColor3f(0.1f,0,0);
				glVertex2f(to2.x,   to2.y);

				glVertex2f(to.x,   to.y);
				glVertex2f(k.x,   k.y);
				k-=n*14;
				glVertex2f(to.x,   to.y);
				glVertex2f(k.x,   k.y);

			glEnd();
		}
	}

	Vector a,b,c;
	float t = gametime*0.002f;

	a = Vector(8 * sinf(t+0*2.094395f+i), 8 * cosf(t+0*2.094395f+i));
	b = Vector(8 * sinf(t+1*2.094395f+i), 8 * cosf(t+1*2.094395f+i));
	c = Vector(8 * sinf(t+2*2.094395f+i), 8 * cosf(t+2*2.094395f+i));

	float delta = 0;
	if(pup->pickupsStart!=0)
		delta= 740/float(pup->pickupsStart-1);
	float pos = 30;

	int end = pup->pickupsLeft;
	if(gameModeState==GAME_MODE_STATE_CREATE) end=pup->pickupsStart;

	for(i=0; i<end; i++)
	{

		glColor3f(0,0,0);
		glBegin(GL_LINE_STRIP);
			glVertex2f(pos+a.x, 580+a.y);
			glVertex2f(pos+b.x, 580+b.y);
			glVertex2f(pos+c.x, 580+c.y);
			glVertex2f(pos+a.x, 580+a.y);
		glEnd();
		
		pos+=delta;
	}

	glColor3f(0,0,0);
	if(end==0 && gameModeState!=GAME_MODE_STATE_HELP)
	{
		printSmall("You are done here. Press ESC to save and return to menu.", 260, 360);
	}

}


void drawCreateHud()
{
	int end = map->lastAdded;
	
	// 0, 1 = alussa, 99 vika 
	end = (MAP_POINTS + 1) - (map->lastAdded + 2);//map->lastAdded ;

	const int POINTS = MAP_POINTS - 3;
	const float edge = 1;
	const float w = 1;
	const float space = (800 - edge*2 - POINTS*w) / POINTS;
	glColor3f(0,0,0);
	glBegin(GL_QUADS);
	int i;
	for(i=0; i < end; i++)
	{
		glVertex2f(edge + i*(w+space),		edge);
		glVertex2f(edge + i*(w+space)+w,	edge);
		glVertex2f(edge + i*(w+space)+w,	edge+5);
		glVertex2f(edge + i*(w+space),		edge+5);
	}
	glEnd();

	drawHud();

}

void drawBg(float rotx=0.0f, float roty=0.0f, int bw=0, float alpha=1.0f)
{
	const int TILE = 30;
	int xoff = int(rotx+camera->pos.x)%TILE;
	int yoff = int(roty+camera->pos.y)%TILE;

	float mod = 0;
	int tmod  = 0;
	
	int offset_x = 0;
	int offset_y = 0;

	if(gameModeState==GAME_MODE_STATE_PLAY && rotx==0.0f)
	{
		mod = sinf(gametime*0.0021f)*60.0f;
		tmod = gametime*0.01f;
		
		float JUMPMOD = powf((player->jumpTime / 150.0f),2);
		float z = 0.902f - JUMPMOD*0.25f;
		glColor4f(z,z,z,0.3f);

		xoff = int(rotx+camera->pos.x*0.8f)%TILE;
		yoff = int(roty+camera->pos.y*0.8f)%TILE;
	}
	else
	{
		glColor4f(0.802f*alpha, 0.802f*alpha, 0.902f*alpha, alpha*0.3f);
	}
	

	if(bw!=0)
	{
		offset_x = 4;
		offset_y = 3;
		const float c = -0.93f*(1-alpha);
		glColor4f(0.93f+c,0.93f+c,0.93f+c, 0.4f);
	}

	glEnable(GL_BLEND);

	glBegin(GL_LINES);
	int i;
	for(i=-3; i<29; i++)
	{
		glVertex2f(i*30 - xoff, 0   /*+((i-tmod)&10)*mod*/ );
		glVertex2f((i+offset_x)*30 - xoff, 600 /*+((i-tmod)&10)*mod*/ );
	}
	for(i=-3; i<21; i++)
	{
		glVertex2f(0   /*+((i+tmod)&10)*mod*/, (i+offset_y)*30 - yoff);
		glVertex2f(800 /*+((i+tmod)&10)*mod*/, i*30 - yoff);
	}
	glEnd();
}

// -----------------------------

void initGame()
{
	effu = new Effu();;
	map = new Map();
	player = new Player();
	camera = new Camera();
	pup = new Pickups();
	
	generateRandomLevel =false;

	camera->startDrive(map->getLastAddedPos() - Vector(400, 300), 350);
	gameModeState = GAME_MODE_STATE_HELP;
}

void freeGame()
{
	delete map;
	delete player;
	delete camera;
	delete pup;
}

void resetGame(int resetType)
{
	switch(resetType)
	{
	case RESET_ALL:
	{
		delete effu;
		delete map;
		delete player;
		delete camera;
		delete pup;

		effu = new Effu();
		map = new Map();
		player = new Player();
		camera = new Camera();
		pup = new Pickups();

		camera->startDrive(map->getLastAddedPos() - Vector(400, 300), 350);

		gameModeState = GAME_MODE_STATE_HELP;
	} break;
	case RESET_PLAY_MODE:
	{	
		delete effu;
		effu = new Effu();
		delete player;
		pup->resetToOriginal();
		player = new Player();
		camera->startDrive(map->getLastAddedPos() - Vector(400, 300), 50);
	} break;
	case RESET_LEVEL_MODE:
	{
		delete effu;
		effu = new Effu();
		delete map;
		delete player;
		pup->resetToOriginal();
		map = new Map();
		player = new Player();
	} break;
	};
}

// -----------------------------
void drawGameState()
{

	drawBg();

	switch(gameModeState)
	{
	case GAME_MODE_STATE_HELP:
	case GAME_MODE_STATE_CREATE:
		
		map->draw();
		map->drawGrowIdentifier();
		player->draw();
		pup->draw();
		drawCreateHud();

		if(gameModeState==GAME_MODE_STATE_HELP)
		{

			glColor4f(1,1,1,0.7f);
			glBegin(GL_QUADS);
			glVertex2f(0,0);
			glVertex2f(800,0);
			glVertex2f(800,600);
			glVertex2f(0,600);
			glEnd();

			glColor3f(0,0,0);
			print("INTRODUCTION", 100, 70);
			
			printSmall("USE YOUR BUMPCRAFT TO COLLECT THE TRIANGLES FROM THE LEVEL", 100, 130);
			
			printSmall("First you will create the level - then play it.", 100, 150);

			printSmall("BUILD MODE", 100, 200);
			printSmall("Build the ground by placing lines. Waving red-blue line", 100, 220);
			printSmall("shows the direction where next one will be added.", 100, 240);

			printSmall("GAME MODE", 100, 300);
			printSmall("Play the level. Navigate or let your bumpcraft", 100, 320);
			printSmall("navigate through the level you built and collect", 100, 340);
			printSmall("all triangles from the level.", 100, 360);

			printSmall("Red-Black arrows show you the direction and distance of the next triangle.", 100, 420);
			printSmall("Controls for each mode are listed on the topleft corner of the screen.", 100, 440);
			printSmall("Press SPACE to START when ready.", 100, 470);
		}
		else 
		{
			printSmall("BUILD MODE", 10, 33);
			printSmall("Press SPACE to place piece of track", 14,45);
			printSmall("Press ENTER to play the level", 14,55);
			printSmall("Press R to restart track construction",14,65);
		}

		break;
	case GAME_MODE_STATE_PLAY:
		
		map->draw();
		player->draw();
		pup->draw();
		effu->draw();
		

		drawHud();
		
			printSmall("GAME MODE", 10, 33);
			printSmall("Press SPACE to jump high", 14,45);
			printSmall("Press R save score and restart drive",14,55);
			printSmall("Press ESC to save and go to menu", 14,65);
		
		break;
	case GAME_MODE_STATE_SCORE:

		map->draw();
		player->draw();
		pup->draw();

		break;
	}
}

void updateGameState(int delta)
{

	if(keyEscape)
	{
		// STORE RESULTS?
		//changeState(1);//TO MENU
		endGame();
		keyEscape=false;
	}

	if(keyR)
	{
		if(gameModeState == GAME_MODE_STATE_CREATE)
		{
			resetGame(RESET_LEVEL_MODE);
			camera->startDrive(map->getLastAddedPos() - Vector(400, 300), 350);
		}
		else if(gameModeState == GAME_MODE_STATE_PLAY)
		{
			saveScore();
			resetGame(RESET_PLAY_MODE);
		}
		keyR = false;
	}


	switch(gameModeState)
	{
	case GAME_MODE_STATE_HELP:
		
		if(keyUp || keySpace || keyEnter)
		{
			gameModeState = GAME_MODE_STATE_CREATE;
			keyUp = keySpace = keyEnter = false;
		}

		camera->update(delta);

		break;
	case GAME_MODE_STATE_CREATE:

		camera->update(delta);

		if(keyEnter)
		{
			gameModeState = GAME_MODE_STATE_PLAY;
			keyEnter = false;
		}

		if(keyUp || keySpace)
		{
			Vector to = map->getGrowIdentifier(true);
			map->addPoint(to);
			camera->startDrive(to - Vector(400, 300), 350);
			
			keyUp=keySpace=false;
		}
		
		break;
	case GAME_MODE_STATE_PLAY:
		

		player->update(delta);
		camera->setPosition(player->pos - Vector(400, 300));
		camera->update(delta);
		pup->update(delta);
		effu->update(delta);
		
		break;
	case GAME_MODE_STATE_SCORE:

		break;
	}
}


// ------------
// Menustate
// ------------

void initMenu()
{
	menuItems = new MenuItem[MENU_ITEMS];

	activeItem = 0;
	fadeTime=-10;

	srand(148);

	int i;
	for(i=0; i<MENU_ITEMS; i++)
	{
		menuItems[i].pos = RRect(0, 0, 40, 40);
		
		float mod = (i/(float)MENU_ITEMS);
		//mod=sinf(mod*1.570796f);
		float radiusw = 300.0f;// * mod;
		float radiush = 200.0f;// * mod;
		
		float angle = -3.141592f + mod * 6.28f;//i*2.094395f;
		menuItems[i].pos.setX(400 + cosf(angle)*radiusw - 20);//offsetsize
		menuItems[i].pos.setY(350 + sinf(angle)*radiush - 20);//offsetsize

		menuItems[i].trianglesAvailable = (int)((i+1));
		if(i==0) menuItems[i].trianglesAvailable = 1;
		if(i==9) menuItems[i].trianglesAvailable = 20;

		menuItems[i].trianglesCollected = 0;
		menuItems[i].deactivateTime = -1;
	}
}

// alpha.. :-)
// last minute hack to make menu look neat.
void drawMenu(float alpha)
{
	int i;
	const float t = 0.0005*gametime;

	// Triangle vertices
	Vector a,b,c,d,e;
	const float angle = 1.2566f;
	a = Vector(sinf(t+angle*0), cosf(t+angle*0));
	b = Vector(sinf(t+angle*1), cosf(t+angle*1));
	c = Vector(sinf(t+angle*2), cosf(t+angle*2));
	d = Vector(sinf(t+angle*3), cosf(t+angle*3));
	e = Vector(sinf(t+angle*4), cosf(t+angle*4));


	drawBg(a.x*435.0f, a.y*435.0f,1,alpha);

	// Lines
	glColor4f(0.7f,0.7f,0.7f, alpha);
	for(i=1; i<MENU_ITEMS; i++)
	{
		MenuItem it1 = menuItems[i-1];
		MenuItem it2 = menuItems[i];

		Vector center1 = Vector(it1.pos.getX() + it1.pos.getW()/2, it1.pos.getY() + it1.pos.getH()/2);
		Vector center2 = Vector(it2.pos.getX() + it2.pos.getW()/2, it2.pos.getY() + it2.pos.getH()/2);

		glBegin(GL_LINES);
			glVertex2f(center1.x, center1.y);
			glVertex2f(center2.x, center2.y);
		glEnd();
	}

	// Triangles
	Vector center;
	for(i=0; i<MENU_ITEMS; i++)
	{
		MenuItem it = menuItems[i];
		center = Vector(it.pos.getX() + it.pos.getW()/2, it.pos.getY() + it.pos.getH()/2);
		
		float rad1 = 25.0f;
		float rad2 = 25.0f;

			
		if(activeItem==i || it.deactivateTime>=0)
		{

			float mod = 1.0f;
			if(it.deactivateTime>=0) mod = it.deactivateTime/350.0f;

			rad1 = 25 + (1.95f+cosf(gametime*0.0025f))*15.0f*mod;
			//rad2 = 25 + (1.95f+sf(time*0.0025f))*15.0f*mod;
			rad2=rad1;
		}


		float col = 0.35f*(it.trianglesCollected/(float)it.trianglesAvailable)*alpha;

		glColor4f(1-col*1.0f,1-col*1.0f,1-col*1.0f, alpha);
		glBegin(GL_TRIANGLE_FAN);
			glVertex2f(center.x+a.x*rad1, center.y+a.y*rad2);
			glVertex2f(center.x+b.x*rad1, center.y+b.y*rad2);
			glVertex2f(center.x+c.x*rad1, center.y+c.y*rad2);
			glVertex2f(center.x+d.x*rad1, center.y+d.y*rad2);
			glVertex2f(center.x+e.x*rad1, center.y+e.y*rad2);
			glVertex2f(center.x+a.x*rad1, center.y+a.y*rad2);
		glEnd();

		glColor4f(0,0,0, alpha);
		glBegin(GL_LINE_STRIP);
			glVertex2f(center.x+a.x*rad1, center.y+a.y*rad2);
			glVertex2f(center.x+b.x*rad1, center.y+b.y*rad2);
			glVertex2f(center.x+c.x*rad1, center.y+c.y*rad2);
			glVertex2f(center.x+d.x*rad1, center.y+d.y*rad2);
			glVertex2f(center.x+e.x*rad1, center.y+e.y*rad2);
			glVertex2f(center.x+a.x*rad1, center.y+a.y*rad2);
		glEnd();
	}

	// Text output

	glColor3f(0,0,0);
	printCenteredX("B U M P C R A F T", 400, 75);
	
	char buf[250];
	sprintf(buf, "Stage %d", (activeItem+1));
	printCenteredX(buf, 400, 335);

	// Success counter
	float delta = 200;
	center = Vector(200, 400);
	if(menuItems[activeItem].trianglesAvailable==1) 
	{ 
		center.x = 400;
	} 
	else 
	{
		delta = 400/(menuItems[activeItem].trianglesAvailable -1);
	}

	glLineWidth(1);

	for(i=0; i<menuItems[activeItem].trianglesAvailable; i++) 
	{
		float rad1 = 10.0f;
		float rad2 = 10.0f;

		
		if(i<menuItems[activeItem].trianglesCollected)
		{
			
			glColor4f(1-0.35f,1-0.35f,1-0.35f,(1-fadeTime/250.0f)*alpha);
			glBegin(GL_TRIANGLE_FAN);
				glVertex2f(center.x+e.x*rad1, center.y+e.y*rad2);
				glVertex2f(center.x+d.x*rad1, center.y+d.y*rad2);
				glVertex2f(center.x+c.x*rad1, center.y+c.y*rad2);
				glVertex2f(center.x+b.x*rad1, center.y+b.y*rad2);
				glVertex2f(center.x+a.x*rad1, center.y+a.y*rad2);
			glEnd();
		}

		glColor4f(0,0,0,(1-fadeTime/250.0f)*alpha);
		glBegin(GL_LINE_STRIP);
			glVertex2f(center.x+a.x*rad1, center.y+a.y*rad2);
			glVertex2f(center.x+b.x*rad1, center.y+b.y*rad2);
			glVertex2f(center.x+c.x*rad1, center.y+c.y*rad2);
			glVertex2f(center.x+d.x*rad1, center.y+d.y*rad2);
			glVertex2f(center.x+e.x*rad1, center.y+e.y*rad2);
			glVertex2f(center.x+a.x*rad1, center.y+a.y*rad2);
		glEnd();

		center.x+=delta;
	}
	glLineWidth(3);

	glColor4f(1,1,1,alpha);
	glBegin(GL_QUADS);
		glVertex2f(642, 575);
		glVertex2f(795, 575);
		glVertex2f(795, 595);
		glVertex2f(642, 595);
	glEnd();

	glColor4f(0.2f,0.2f,0.2f,alpha);
	glBegin(GL_LINE_STRIP);
		glVertex2f(642, 575);
		glVertex2f(795, 575);
		glVertex2f(795, 595);
		glVertex2f(642, 595);
		glVertex2f(642, 575);
	glEnd();
	
	printSmall(" Click for [R]andom Level", 656, 589);
	
	int total=0, collected=0;
	for(i=0; i<MENU_ITEMS; i++)
	{
		total+=menuItems[i].trianglesAvailable;
		collected+=menuItems[i].trianglesCollected;
	}

	sprintf(buf," Total Progress: %d%%", (100*collected/total));
	printSmall(buf, 20, 589);

}

void handleMouse(int x, int y)
{
	int i;
	for(i=0; i<MENU_ITEMS; i++)
	{
		if(menuItems[i].pos.isIn(x,y))
		{
			if(activeItem!=i)
			{
				activeItem=i;
				menuItems[i].deactivateTime=350;
				fadeTime = 250;
			}

			if(mouseLeft || mouseRight)
				changeState(3);//GAME_PLAY;
		}
	}

	RRect random = RRect(642,575, 153,20);
	if(random.isIn(x,y))
	{
		if(mouseLeft || mouseRight)
		{
			generateRandomLevel = true;
			changeState(3);//GAME_PLAY;
		}
	}
}

void updateMenu(int delta)
{

	if(keyLeft)
	{
		activeItem--;
		if(activeItem<0) activeItem+=10;
		keyLeft = false;
	}
	if(keyRight)
	{
		activeItem++;
		keyRight = false;
	}	
	
	if(keyR)
	{
		generateRandomLevel = true;
		changeState(3);
	}

	activeItem = abs(activeItem)%MENU_ITEMS;

	int i;
	for(i=0; i<MENU_ITEMS; i++)
	{
		if(activeItem!=i && menuItems[i].deactivateTime>=0)
		{
			menuItems[i].deactivateTime-=delta;
		}
	}

	if(fadeTime>=0)
		fadeTime-=delta;
}

void saveScore()
{
	int collected = pup->pickupsStart - pup->pickupsLeft;
	if(collected > menuItems[activeItem].trianglesCollected)
		menuItems[activeItem].trianglesCollected = collected;
}

void endGame()
{
	saveScore();
	changeState(1);
}


// ----------------------------


void Effu::draw()
{
	if(timeLeft<0) return;

	float c = 1-timeLeft/300.0f;
	c =c*c;
	glColor3f(c,c,c);
	

	glBegin(GL_POINTS);
	for(int i=0; i<EFFU_COUNT; i++)
		glVertex2f(pos[i].x - camera->pos.x, pos[i].y - camera->pos.y);
	glEnd();
};
