
/**
 *  BUMPCRAFT
 *  ludumdare #9 entry (48hour game dev compo)
 *  
 * please, do not use this code for learning purposes
 * it was coded in hurry, because of the timeline
 * and most of the parts in this source have been iterated
 * multiple times to make gameplay fun - so readability and
 * maintainability of this piece of code was lost in the process
 * and the whole deal is designed badly from the beginning
 * 
 * if you find this piece of code handy or have something 
 * to ask about it feel free to contact me..
 *
 * written by rauli laatikainen - rale@bombsquad.org
 **/

#ifndef LINUX
#include "SDL.h"
#include "SDL_opengl.h"
#else
#include <SDL/SDL.h>
#endif

#include "rgl.h"
#include "playstate.h"
#include "soundsystem.h"

using namespace std;

int OPENGL_WIDTH;
int OPENGL_HEIGHT;

// ---------------------------------------------------------------------

RRect screenArea;
Vector mouse;

// audio
SoundSystem *sound;

// funtion prototypes
void draw();
void update(int delta);

// timer
Uint32 gametime;	// synonym for frametimelast
Uint32 frametimelast;
Uint32 deltatime;
Uint32 deltacapped;
bool drawFrame;
void updateTimer();
void initTimer();

// used on some states:)
int stateTimer;

// state machine
int gameState;
const int GAME_STARTUP	   = 0;
const int GAME_MENU		   = 1;
const int GAME_INSTRUCTION = 2;
const int GAME_PLAY		   = 3;
const int GAME_QUIT		   = 4;
const int GAME_STATES	   = 5;

int nextState;

void updateState();
void changeState(int toId);


// keyboard
// Events
bool handleEvents();
bool keyEnter;
bool keyEscape;
bool keySpace;
bool keyUp;
bool keyDown;
bool keyLeft;
bool keyRight;
bool mouseLeft;
bool mouseRight;
bool keyR;
bool done;

int main( int argc, char *argv[] ) 
{
	

	freopen("CON", "wt", stdout );
	freopen("CON", "wt", stderr );
	freopen("CON", "wt", stderr);

	//printf("::Starting\n");

	OPENGL_WIDTH  = 800;
	OPENGL_HEIGHT = 600;

	screenArea = RRect(0,0,OPENGL_WIDTH,OPENGL_HEIGHT);

	bool fullscreen = false;
	int iResults = MessageBox((HWND)wglGetCurrentDC(),"Fullscreen?", "BUMPCRAFT", MB_YESNO );
	if(iResults==IDNO) fullscreen = false; else fullscreen = true;

	setup_sdl("Bumpcraft | 48 hour game for LD#9", OPENGL_WIDTH, OPENGL_HEIGHT, 32, fullscreen); // fullscreen
	setup_window("Bumpcraft | 48 hour game for LD#9", OPENGL_WIDTH, OPENGL_HEIGHT, 32, fullscreen);
	setup_opengl(OPENGL_WIDTH, OPENGL_HEIGHT);

	sound = new SoundSystem;
	sound->init();
	
	font_init();
	initMenu();
	initGame();

	// ----

	gameState = 0;
	nextState = -1;
	keyUp = false;
	keyDown = false;
	keyLeft = false;
	keyRight = false;
	done = false;
	// ----

	perspective2D(800, 600);

	initTimer();

	// ----

	while(!done)
	{
		
		updateTimer();
		
		update(deltatime);
			
		draw();
		
		if(handleEvents()) done = true;
		
		updateState();

		
	}

	// ----

	freeGame();

	perspective3D();

	//printf("::Closing down\n");
	
	delete sound;
		
	SDL_Quit();
	return 0;
}

// ----------------------------------------

void update(int delta)
{
	switch(gameState)
	{

		case GAME_STARTUP:

			stateTimer+=delta;
			if(stateTimer>700)
				//changeState(GAME_PLAY);
				changeState(GAME_MENU);

				
			break;
		case GAME_PLAY:

			updateGameState(delta);

			break;
		case GAME_MENU:

			if(keyEscape)
			{
				changeState(GAME_QUIT);
			}
			
			if(keySpace || keyEnter)
			{
				changeState(GAME_PLAY);
				keySpace = keyEnter = false;
			}

			updateMenu(delta);
			
			handleMouse(mouse.x, mouse.y);

			break;
		case GAME_QUIT:
			stateTimer+=delta;
			if(stateTimer>500)
				done = true;
				
			break;
	}
}

void draw()
{

	glLineWidth(3);

	glClear(GL_COLOR_BUFFER_BIT);
	glDisable(GL_TEXTURE_2D);

	
	switch(gameState)
	{

		case GAME_STARTUP:
		{
			float c;
			if(stateTimer > 700.0f) c = 1.0f;
			else 
			{
				const float m = (stateTimer/700.0f);
				c = m;
			}
			
			glColor3f(c,c,c);
			glBegin(GL_QUADS);
				glVertex2f(0,  0);
				glVertex2f(800,0);
				glVertex2f(800,600);
				glVertex2f(0,  600);
			glEnd();
	
			/*
			const float d = (c-0.7f>0 ? c-0.7f : 0);
			glColor3f(d,d,d);
			printCenteredX("GAMENAME", 400, 300);
			*/	

			drawMenu(c);
		} break;
		case GAME_MENU:
		{
			drawMenu(1);
			/*
			const float d = 0.3f;
			glColor3f(d,d,d);
			printCenteredX("GAMENAME", 400, 300);
			*/

		} break;

		case GAME_PLAY:
		{	
			drawGameState();

		} break;
		case GAME_QUIT:
		{
			float c;
			if(stateTimer > 500.0f) c = 0.0f;
			else 
			{
				const float m = (stateTimer/300.0f);
				c = 1 - m*m;
			}
			
			glColor3f(c,c,c);
			glBegin(GL_QUADS);
				glVertex2f(0,  0);
				glVertex2f(800,0);
				glVertex2f(800,600);
				glVertex2f(0,  600);
			glEnd();

			const float d = (c+0.2f<1 ? c+0.2f : 1);
			glColor3f(d,d,d);
			drawMenu(c);
		} break;
	}

	SDL_GL_SwapBuffers();
}

// ----------------------------------------

bool handleEvents()
{
	SDL_Event event;

	while(SDL_PollEvent(&event))
	{
		switch(event.type)
		{  
			case SDL_KEYDOWN:  
				switch( event.key.keysym.sym )
				{
					case SDLK_RETURN:
						keyEnter = true;
					break;
					case SDLK_ESCAPE:
						keyEscape = true;
						break;
					case SDLK_r:
						keyR = true;
						break;
					case SDLK_SPACE:
						keySpace = true;
						break;
					case SDLK_LEFT:
						keyLeft = true;
						break;
					case SDLK_RIGHT:
						keyRight = true;
						break;
					case SDLK_UP:
						keyUp = true;
						break;	
					case SDLK_DOWN:
						keyDown = true;
						break;
				}
				
				break;

			case SDL_KEYUP:
				switch( event.key.keysym.sym )
				{
					case SDLK_RETURN:
						keyEnter = false;
					break;
					case SDLK_ESCAPE:
						keyEscape = false;
					break;
					case SDLK_r:
						keyR = false;
						break;
					case SDLK_SPACE:
						keySpace = false;
						break;
					case SDLK_LEFT:
						keyLeft = false;
						break;
					case SDLK_RIGHT:
						keyRight = false;
						break;
					case SDLK_UP:
						keyUp = false;
						break;	
					case SDLK_DOWN:
						keyDown = false;
						break;
				}
				break;

			case SDL_MOUSEBUTTONDOWN:
				if(event.button.button == SDL_BUTTON_RIGHT) 
					mouseRight = true;
				
				if(event.button.button == SDL_BUTTON_LEFT) 
					mouseLeft  = true;

				break;
			case SDL_MOUSEBUTTONUP:
				if(event.button.button == SDL_BUTTON_RIGHT) 
					mouseRight = false;
				
				if(event.button.button == SDL_BUTTON_LEFT) 
					mouseLeft  = false;
					
			case SDL_MOUSEMOTION:

				mouse.x = event.motion.x;
				mouse.y = event.motion.y;

				break;
			case SDL_QUIT:
				return true;
				break;
			default:
			  break;
		}
	}

	return false;
}

// ----------------------------------------

void updateTimer()
{
	Uint32 getticks = SDL_GetTicks();

	const int MAX_FPS = 150;
	if(getticks-frametimelast<1000/MAX_FPS) 
	  SDL_Delay( Uint32 ((1000/MAX_FPS) - (getticks-frametimelast)) );

	getticks = SDL_GetTicks();
	deltatime = getticks - frametimelast;
	frametimelast = getticks;
	gametime = frametimelast;

	//char buf[150];
	//sprintf(buf, "delta %d  -  getticks %d \n", deltatime, getticks);
	//printf("%s", buf);
}

void initTimer()
{
	Uint32 getticks = SDL_GetTicks();
	frametimelast = getticks;
}

// ----------------------------------------

void updateState()
{
	if(nextState!=-1)
	{
		gameState=nextState;

		if(nextState==GAME_PLAY)
		{
			resetGame(RESET_ALL);
		}

		nextState = -1;
		stateTimer = 0;
	}
}

void changeState(int toId)
{
	nextState = toId;
}


// ----------------------------------------