
/**
 *	Please do not read this source code if you want to
 *  keep up your good coding practises. This game is written in
 *  less than 12 hours from zero to final game. So the quality of
 *  code was the very first thing i decided to drop to keep up..
 **/

#ifndef LINUX
#include "SDL.h"
#include "SDL_opengl.h"
#include "SDL_image.h"
#else
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#endif

#include "common.h"
#include "soundsystem.h"
#include "game.h"

#define min(a,b) (a < b ? a : b)
#define max(a,b) (a > b ? a : b)

using namespace std;

int currentLevel;
const float INTRO_TIME = 750;
float introTimer;
float quitTimer;
const float QUIT_TIMER_GOAL = 1000;
int OPENGL_WIDTH;
int OPENGL_HEIGHT;
int chapterSelected;

extern bool tutorialShow;

void drawIntro();
void drawMenu();
void drawHelp();
void drawChapters();
void updateIntro(float delta);
void updateMenu(float delta);
void updateHelp(float delta);
void updateChapters(float delta);
void initMenu();
void addParticlesRRect(RRect c);
// ---------------------------------------------------------------------
void drawPlayButton();
extern void freeParticles();
extern void initParticles();
extern void killParticles();
extern void updateParticles(int deltatime);
extern void drawParticles();
extern void addParticle(int type, Vector pos);
extern void addParticlesOnLine(Vector a, Vector b, int n);
extern void addParticlesOnLine2(Vector a, Vector b, int n);
extern void addParticlesOnLine3(Vector a, Vector b, int n);

const int LEVEL_COUNT = 25;
const char *levelNames[LEVEL_COUNT] = 
{
	"Easy start",
	"PT2",
	"Signature",
	"New shapes",
	"Angular speeds",
	"Rounds",
	"Nonagon brothers",
	"Pattern matching",
	"Symmetricity",
	"Swarm",
	"Park",
	"Unknown",
	"Mixed set",
	"Movie",
	"Aim your shots!",
	"Big bad blocks",
	"Field of triangles",
	"Merry go round",
	"Chained shots",
	"Moving target",
	"Hidden targets",
	"Mass chains",
	"Mass effect",
	"Level name",
	"Final level"
};


int hoveredItem = -1;
int menuItemCount;
RRect *menuItems;
const char *menuItemText[] =
{
	"Play", "Level selection", "How to play", "Level editor", "Quit"
};

RRect backButton;
RRect playButton;

Vector mouse;

// audio
SoundSystem *sound;

// funtion prototypes
void draw();
void update(int delta);

// timer
Uint32 gametime;	// synonym for frametimelast
Uint32 frametimelast;
Uint32 deltatime;
Uint32 deltacapped;
bool drawFrame;
void updateTimer();
void initTimer();

// keyboard
// Events
bool handleEvents();
bool keyEnter;
bool keyEscape;
bool keySpace;
bool keyUp;
bool keyDown;
bool keyLeft;
bool keyRight;
bool keyO;
bool keyS;
bool keyN;
bool mouseLeft;
bool mouseRight;
bool keyR;
bool keyQ;
bool keyW;
bool done;

Texture *logo;
Texture *texture;
Texture *texture2;

enum
{
	STATE_INTRO,
	STATE_MENU,
	STATE_HELP,
	STATE_CHAPTERS,
	STATE_GAME,
	STATE_EDITOR,
	STATE_COUNT
};

int gameState;
int newGameState;

void changeState(int newstate)
{
	mouseLeft = false;
	newGameState = newstate;
}

void updateStateMachine()
{
	if(newGameState != -1)
	{
		if(gameState != STATE_INTRO) sound->play(1);
		gameState = newGameState;
		newGameState = -1;
		
		mouseLeft = false;
		if(gameState==STATE_GAME)
		{
			startGamePlay(currentLevel);
		}
		else 
		if(gameState==STATE_EDITOR)
		{
			tutorialShow=true; 
		}
	}
}


void freeResources()
{
	freeParticles();
	freeGameResources();
}

int main( int argc, char *argv[] ) 
{
	freopen("CON", "wt", stdout );
	freopen("CON", "wt", stderr );
	freopen("CON", "wt", stderr);

	currentLevel = 0;
	OPENGL_WIDTH  = 1024;
	OPENGL_HEIGHT = 768;

	bool fullscreen = false;
	
	/*if(MessageBox((HWND)wglGetCurrentDC(),"Fullscreen?", "Boostcraft", MB_YESNO )==IDNO) 
		fullscreen = false; 
	else 
		fullscreen = true;
	*/

	setup_sdl("Boostcraft | Ludumdare 10 'Chain reactions' | R.Laatik. dec'07", OPENGL_WIDTH, OPENGL_HEIGHT, 32, fullscreen); // fullscreen
	setup_window("Boostcraft | Ludumdare 10 'Chain reactions' | R.Laatik. dec'07", OPENGL_WIDTH, OPENGL_HEIGHT, 32, fullscreen);
	setup_gl(OPENGL_WIDTH, OPENGL_HEIGHT);

	sound = new SoundSystem;
	sound->init();
	
	glLineWidth(2);

	font_init();

	logo = new Texture;
	load_texture("./data/boostcraft.jpg", logo);
	texture = new Texture;
	load_texture("./data/flare.jpg", texture);
	texture2 = new Texture;
	load_texture("./data/flare_chain.jpg", texture2);
	
	chapterSelected = 0;

	newGameState = -1;
	gameState = STATE_INTRO;

	initParticles();

	initMenu();
	backButton = RRect(OPENGL_WIDTH*0.5-125, OPENGL_HEIGHT-145, 250, 50);	
	playButton = RRect(OPENGL_WIDTH*0.5-150, OPENGL_HEIGHT-145-70, 300, 50);	

	// ----

	keyUp = false;
	keyDown = false;
	keyLeft = false;
	keyRight = false;
	keyQ = false;
	keyW = false;
	keyO = false;
	keyS = false;
	keyN = false;
	keyEscape = false;
	keyEnter = false;
	mouseLeft = false;
	mouseRight = false;
	done = false;

	// ----
	// Game stuff
	// ----

	initLevelData();

	// ----

	perspective2D(OPENGL_WIDTH, OPENGL_HEIGHT);

	initTimer();
	glClearColor(0,0,0,0);

	// ----


	while(!done || quitTimer < QUIT_TIMER_GOAL)
	{
		
		updateTimer();
		
		update(deltatime);
		
		draw();
		
		if(handleEvents()) done = true;

		updateStateMachine();
		
	}

	// ----

	perspective3D();

	//printf("::Closing down\n");
	
	//freeResources();
	delete sound;
		
	SDL_Quit();
	return 0;
}



// ----------------------------------------

void update(int delta)
{
	if(done) 
	{
		quitTimer += delta;
		return;
	}

	updateParticles(delta);

	switch(gameState)
	{
	case STATE_GAME:
			if(updateGame(delta))
			{
				changeState(STATE_MENU);
			}
		break;
	case STATE_INTRO:
			updateIntro(delta);
		break;
	case STATE_MENU:
			updateMenu(delta);
		break;
	case STATE_HELP:
			updateHelp(delta);
		break;
	case STATE_EDITOR:
			if(updateEditor(delta)) changeState(STATE_MENU);
		break;
	case STATE_CHAPTERS:
			updateChapters(delta);
		break;
	}
}



void draw()
{
	glClear(GL_COLOR_BUFFER_BIT);

	switch(gameState)
	{
	case STATE_GAME:
		drawGame();
		break;
	case STATE_INTRO:
		drawIntro();
		break;
	case STATE_MENU:
		drawMenu();
		break;
	case STATE_HELP:
		drawHelp();
		break;
	case STATE_EDITOR:
		drawEditor();
		break;
	case STATE_CHAPTERS:
		drawChapters();
		break;
	}

	if(done || gameState == STATE_INTRO)
	{
		float c = quitTimer/QUIT_TIMER_GOAL;

		if(gameState == STATE_INTRO)
		{
			c = 1-introTimer/INTRO_TIME;
		}

		int h = c*c* OPENGL_HEIGHT * 0.5f;
		int w = c*c*c * OPENGL_WIDTH * 0.5f;
		if(gameState!=STATE_INTRO) w = (0.35f*c+sinf(c*c*c*7.0f)*0.25) * OPENGL_WIDTH * 0.5f;

		glColor3f(1,1,1);

		glBegin(GL_QUADS);
			glVertex2f(0,0);
			glVertex2f(0, h);
			glVertex2f(OPENGL_WIDTH, h);
			glVertex2f(OPENGL_WIDTH, 0);

			glVertex2f(0, OPENGL_HEIGHT);
			glVertex2f(0, OPENGL_HEIGHT-h);
			glVertex2f(OPENGL_WIDTH, OPENGL_HEIGHT-h);
			glVertex2f(OPENGL_WIDTH, OPENGL_HEIGHT);

			glVertex2f(0,0);
			glVertex2f(0, OPENGL_HEIGHT);
			glVertex2f(w, OPENGL_HEIGHT);
			glVertex2f(w, 0);

			glVertex2f(OPENGL_WIDTH, 0);
			glVertex2f(OPENGL_WIDTH-w, 0);
			glVertex2f(OPENGL_WIDTH-w, OPENGL_HEIGHT);
			glVertex2f(OPENGL_WIDTH, OPENGL_HEIGHT);

		glEnd();
		
	}
	
	
	// draw
	SDL_GL_SwapBuffers();
}

// ----------------------------------------

bool handleEvents()
{
	SDL_Event event;

	while(SDL_PollEvent(&event))
	{
		switch(event.type)
		{  
			case SDL_KEYDOWN:  
				switch( event.key.keysym.sym )
				{
					case SDLK_RETURN:
						keyEnter = true;
					break;
					case SDLK_ESCAPE:
						keyEscape = true;
						break;
					case SDLK_r:
						keyR = true;
						break;
					case SDLK_SPACE:
						keySpace = true;
						break;
					case SDLK_LEFT:
						keyLeft = true;
						break;
					case SDLK_RIGHT:
						keyRight = true;
						break;
					case SDLK_s:
						keyS = true;
						break;
					case SDLK_q:
						keyQ = true;
						break;
					case SDLK_w:
						keyW = true;
						break;
					case SDLK_o:
						keyO = true;
						break;
					case SDLK_n:
						keyN = true;
						break;
					case SDLK_UP:
						keyUp = true;
						break;	
					case SDLK_DOWN:
						keyDown = true;
						break;
				}
				
				break;

			case SDL_KEYUP:
				switch( event.key.keysym.sym )
				{
					case SDLK_RETURN:
						keyEnter = false;
					break;
					case SDLK_ESCAPE:
						keyEscape = false;
					break;
					case SDLK_s:
						keyS = false;
						break;
					case SDLK_q:
						keyQ = false;
						break;
					case SDLK_w:
						keyW = false;
						break;
					case SDLK_o:
						keyO = false;
						break;
					case SDLK_n:
						keyN = false;
						break;
					case SDLK_r:
						keyR = false;
						break;
					case SDLK_SPACE:
						keySpace = false;
						break;
					case SDLK_LEFT:
						keyLeft = false;
						break;
					case SDLK_RIGHT:
						keyRight = false;
						break;
					case SDLK_UP:
						keyUp = false;
						break;	
					case SDLK_DOWN:
						keyDown = false;
						break;
				}
				break;

			case SDL_MOUSEBUTTONDOWN:
				if(event.button.button == SDL_BUTTON_RIGHT) 
					mouseRight = true;
				
				if(event.button.button == SDL_BUTTON_LEFT) 
				{
					mouseLeft  = true;
					if(gameState!=STATE_GAME)
					{
						for(int n=0; n<10; n++)
						addParticle(1, mouse);
					}
				}

 				break;
			case SDL_MOUSEBUTTONUP:
				if(event.button.button == SDL_BUTTON_RIGHT) 
					mouseRight = false;
				
				if(event.button.button == SDL_BUTTON_LEFT) 
					mouseLeft  = false;
					
			case SDL_MOUSEMOTION:
			{

				mouse.x = event.motion.x;
				mouse.y = event.motion.y;
				if(gameState != STATE_EDITOR && gameState != STATE_GAME)
				for(int n=0; n<1; n++)
				{
					addParticle(1, mouse);
				}

			}
				break;
			case SDL_QUIT:
				return true;
				break;
			default:
			  break;
		}
	}

	return false;
}

// ----------------------------------------

void updateTimer()
{
	Uint32 getticks = SDL_GetTicks();

	const int MAxFPS = 100;
	if(getticks-frametimelast<1000/MAxFPS) 
	  SDL_Delay( Uint32 ((1000/MAxFPS) - (getticks-frametimelast)) );

	getticks = SDL_GetTicks();
	deltatime = getticks - frametimelast;
	frametimelast = getticks;
	gametime = frametimelast;
}

void initTimer()
{
	Uint32 getticks = SDL_GetTicks();
	frametimelast = getticks;
}

// ----------------------------------------

void drawIntro()
{
	drawBackground2();

	glDisable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glColor3f(1,1,1);

}
void updateIntro(float delta)
{
	introTimer+=delta;
	if(introTimer > INTRO_TIME) changeState(STATE_MENU);
	if(mouseLeft)
	{
		introTimer  = INTRO_TIME;
	}
}

void drawMenu()
{
	drawBackground2();
	glColor3f(1,1,1);

	glEnable(GL_TEXTURE_2D);
	float f = powf(sinf(gametime*0.001f),3)*0.0185f;
	RRect to(OPENGL_WIDTH*0.5-logo->width*0.5f, 30, logo->width, logo->height);
	drawSprite(to, logo, 0, 1.0f+f);
	glDisable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	int n;
	for(n=0; n<menuItemCount; n++)
	{
		glDisable(GL_BLEND);
		glColor3f(0.68f, 0.68f, 0.9f);
		glBegin(GL_LINE_STRIP);
			glVertex2f(menuItems[n].getX(), menuItems[n].getY());
			glVertex2f(menuItems[n].getX(), menuItems[n].getY()+menuItems[n].getH());
			glVertex2f(menuItems[n].getX()+menuItems[n].getW(), menuItems[n].getY()+menuItems[n].getH());
			glVertex2f(menuItems[n].getX()+menuItems[n].getW(), menuItems[n].getY());
			glVertex2f(menuItems[n].getX(), menuItems[n].getY());
		glEnd();

		glEnable(GL_BLEND);
		//glColor3f(1.0f, 1.0f, 1.0f);
		if(hoveredItem == n) glColor3f(0.4f, 0.4f, 0.4f); else glColor3f(1,1,1);
		int centerx = OPENGL_WIDTH>>1;
		int centery =  menuItems[n].getY()+menuItems[n].getH()/2 + 5;
		printCenteredX(menuItemText[n], centerx, centery);
	
	}
}
void updateMenu(float delta)
{
	hoveredItem = -1;
	int n;
	for(n=0; n<menuItemCount; n++)
	{
		if(menuItems[n].isIn(mouse.x, mouse.y))
			hoveredItem = n;
	}

	if(mouseLeft && hoveredItem!=-1)
	{
		if(hoveredItem == 0) changeState(STATE_GAME);
		if(hoveredItem == 1) changeState(STATE_CHAPTERS);
		if(hoveredItem == 2) changeState(STATE_HELP);
		if(hoveredItem == 3) changeState(STATE_EDITOR);
		if(hoveredItem == 4) done = true;

		mouseLeft = false;
	}

}

void drawHelp()
{
	drawBackground2();

	glEnable(GL_TEXTURE_2D);
	float f = powf(sinf(gametime*0.001f),3)*0.0185f;
	RRect to(OPENGL_WIDTH*0.5-logo->width*0.5f, 30, logo->width, logo->height);
	drawSprite(to, logo, 0, 1.0f+f);
	glDisable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	glColor3f(1,1,1);
	printCenteredX("How to play", OPENGL_WIDTH>>1, 200);

	
	int n = 250;
	printCenteredX("The aim of the game is to make", OPENGL_WIDTH>>1, n+=20);
	printCenteredX("every shape on the screen to explode.", OPENGL_WIDTH>>1, n+=20);
	printCenteredX("", OPENGL_WIDTH>>1, n+=20);
	printCenteredX("In the beginning of the level you can", OPENGL_WIDTH>>1, n+=20);
	printCenteredX("click on one shape to make it explode.", OPENGL_WIDTH>>1, n+=20);
	printCenteredX("With this explosion you should try to", OPENGL_WIDTH>>1, n+=20);
	printCenteredX("make as big chain reactions as possible.", OPENGL_WIDTH>>1, n+=20);
	printCenteredX("", OPENGL_WIDTH>>1, n+=20);
	printCenteredX("On each level there is a minimum chain that you", OPENGL_WIDTH>>1, n+=20);
	printCenteredX("need to beat to advance to the next level.", OPENGL_WIDTH>>1, n+=20);

	printCenteredX("", OPENGL_WIDTH>>1, n+=20);


	drawBackButton();
}

void updateHelp(float delta)
{
	if((mouseLeft && backButton.isIn(mouse.x, mouse.y) )|| keyEscape)
	{
		keyEscape = false;
		mouseLeft = false;
		changeState(STATE_MENU);
	}
}

void drawChapters()
{
	drawBackground2();

	glEnable(GL_TEXTURE_2D);
	float f = powf(sinf(gametime*0.001f),3)*0.0185f;
	RRect to(OPENGL_WIDTH*0.5-logo->width*0.5f, 30, logo->width, logo->height);
	drawSprite(to, logo, 0, 1.0f+f);
	glDisable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	glColor3f(1,1,1);
	printCenteredX("Level selection", OPENGL_WIDTH>>1, 200);

	RRect a(OPENGL_WIDTH*0.5f - 70-60, OPENGL_HEIGHT*0.5f - 30, 60, 60);
	RRect b(OPENGL_WIDTH*0.5f + 70, OPENGL_HEIGHT*0.5f - 30, 60, 60);
		
	
	glColor3f(0.68f, 0.68f, 0.9f);
	if(a.isIn(mouse.x, mouse.y)) glColor3f(0.3468f, 0.3468f, 0.569f);
glDisable(GL_BLEND);
	glBegin(GL_LINE_STRIP);

		glVertex2f(OPENGL_WIDTH*0.5f - 70,	OPENGL_HEIGHT*0.5f - 30);
		glVertex2f(OPENGL_WIDTH*0.5f - 130,	OPENGL_HEIGHT*0.5f);
		glVertex2f(OPENGL_WIDTH*0.5f - 70,  OPENGL_HEIGHT*0.5f + 30);
		glVertex2f(OPENGL_WIDTH*0.5f - 70,	OPENGL_HEIGHT*0.5f - 30);

	glEnd();
	

	glColor3f(0.68f, 0.68f, 0.9f);
	if(b.isIn(mouse.x, mouse.y)) glColor3f(0.3468f, 0.3468f, 0.569f);
	glBegin(GL_LINE_STRIP);

		glVertex2f(OPENGL_WIDTH*0.5f + 70,	OPENGL_HEIGHT*0.5f - 30);
		glVertex2f(OPENGL_WIDTH*0.5f + 130,	OPENGL_HEIGHT*0.5f);
		glVertex2f(OPENGL_WIDTH*0.5f + 70,  OPENGL_HEIGHT*0.5f + 30);
		glVertex2f(OPENGL_WIDTH*0.5f + 70,	OPENGL_HEIGHT*0.5f - 30);

	glEnd();
glEnable(GL_BLEND);	

	glColor3f(1,1,1);

	char buf[100];
	sprintf(buf, "Level %d: %s", (1+chapterSelected), levelNames[chapterSelected]);
	printCenteredX(buf, OPENGL_WIDTH>>1, OPENGL_HEIGHT/4*3-90);


	drawBackButton();
	drawPlayButton();
}

void updateChapters(float delta)
{
	if(keyEscape || (mouseLeft && backButton.isIn(mouse.x, mouse.y)) )
	{
		changeState(STATE_MENU);
		keyEscape = false;
		mouseLeft = false;
	}

	
	if(mouseLeft)
	{
		RRect a(OPENGL_WIDTH*0.5f - 70-60, OPENGL_HEIGHT*0.5f - 30, 60, 60);
		if(a.isIn(mouse.x, mouse.y))
		{
			chapterSelected--;
			mouseLeft = false;
			if(chapterSelected < 0) chapterSelected = LEVEL_COUNT-1;		
		}
	
		RRect b(OPENGL_WIDTH*0.5f + 70, OPENGL_HEIGHT*0.5f - 30, 60, 60);
		if(b.isIn(mouse.x, mouse.y))
		{
			chapterSelected++;
			mouseLeft = false;
			if(chapterSelected > LEVEL_COUNT-1) chapterSelected = 0;
		}

		if(playButton.isIn(mouse.x, mouse.y))
		{
			mouseLeft = false;
			currentLevel = chapterSelected;
			//startGamePlay(currentLevel);
			changeState(STATE_GAME);
		}
	}


	if(keyLeft)
	{
		chapterSelected--;
		keyLeft = false;
		if(chapterSelected < 0) chapterSelected = LEVEL_COUNT-1;
	}

	if(keyRight)
	{
		chapterSelected++;
		keyRight = false;
		if(chapterSelected > LEVEL_COUNT-1) chapterSelected = 0;
	}
}


void initMenu()
{
	menuItemCount = 5;
	menuItems = new RRect[menuItemCount];

	int y = 215, margin = 50;
	int n, w=250, h=50;
	for(n=0; n<menuItemCount; n++)
	{
		menuItems[n] = RRect((OPENGL_WIDTH/2)-(w/2), y, w, h);
		y += margin+h;
	}
}

void drawBackButton()
{

	glColor3f(1,1,1);
	glDisable(GL_BLEND);
	glColor3f(0.68f, 0.68f, 0.9f);
	glBegin(GL_LINE_STRIP);
		glVertex2f(backButton.getX(), backButton.getY());
		glVertex2f(backButton.getX(), backButton.getY()+backButton.getH());
		glVertex2f(backButton.getX()+backButton.getW(), backButton.getY()+backButton.getH());
		glVertex2f(backButton.getX()+backButton.getW(), backButton.getY());
		glVertex2f(backButton.getX(), backButton.getY());
	glEnd();

	glEnable(GL_BLEND);
	//glColor3f(1.0f, 1.0f, 1.0f);
	if(backButton.isIn(mouse.x, mouse.y)) glColor3f(0.4f, 0.4f, 0.4f); else glColor3f(1,1,1);
	int centerx = OPENGL_WIDTH>>1;
	int centery =  backButton.getY()+backButton.getH()/2 + 5;
	printCenteredX("Back", centerx, centery);

}

void drawPlayButton()
{

	glColor3f(1,1,1);
	glDisable(GL_BLEND);
	glColor3f(0.68f, 0.68f, 0.9f);
	glBegin(GL_LINE_STRIP);
		glVertex2f(playButton.getX(), playButton.getY());
		glVertex2f(playButton.getX(), playButton.getY()+playButton.getH());
		glVertex2f(playButton.getX()+playButton.getW(), playButton.getY()+playButton.getH());
		glVertex2f(playButton.getX()+playButton.getW(), playButton.getY());
		glVertex2f(playButton.getX(), playButton.getY());
	glEnd();

	glEnable(GL_BLEND);
	//glColor3f(1.0f, 1.0f, 1.0f);
	if(playButton.isIn(mouse.x, mouse.y)) glColor3f(0.4f, 0.4f, 0.4f); else glColor3f(1,1,1);
	int centerx = OPENGL_WIDTH>>1;
	int centery =  playButton.getY()+playButton.getH()/2 + 5;
	printCenteredX("Play", centerx, centery);

}


void addParticlesRRect(RRect c)
{
	addParticlesOnLine2(Vector(c.getX(), c.getY()), Vector(backButton.getX(), backButton.getY()+backButton.getH()), 25);
	addParticlesOnLine2(Vector(backButton.getX()+backButton.getW(), backButton.getY()+backButton.getH()), Vector(backButton.getX()+backButton.getW(), backButton.getY()), 25);
		//glVertex2f(backButton.getX(), backButton.getY());
}