#ifndef _GAME_H_
#define _GAME_H_

#ifndef LINUX
#include "SDL.h"
#include "SDL_opengl.h"
#include "SDL_image.h"
#include "windows.h"
#include "Commdlg.h"
#else
#include <SDL/SDL.h>
#include "SDL/SDL_image.h"
#endif

#include "soundsystem.h"
#include <fstream>

#include "common.h"

#define min(a,b) (a < b ? a : b)
#define max(a,b) (a > b ? a : b)

extern int OPENGL_WIDTH;
extern int OPENGL_HEIGHT;
extern Uint32 gametime;
extern Uint32 frametimelast;
extern Uint32 deltatime;
extern Uint32 deltacapped;
extern bool keyEnter;
extern bool keyEscape;
extern bool keySpace;
extern bool keyUp;
extern bool keyDown;
extern bool keyLeft;
extern bool keyRight;
extern bool mouseLeft;
extern bool mouseRight;
extern bool keyW;
extern bool keyQ;
extern bool keyR;
extern bool keyS;
extern bool keyO;
extern bool keyN;
extern Vector mouse;
extern bool mouseWUp;
extern bool mouseWDown;
extern Texture *texture;
extern Texture *texture2;

// -----------------------
// Game logic
void startGamePlay(int n);

void drawBackButton();
void initLevelData();
void packMap();
void unpackMap();

void drawTextBox();
void updateTextBox(float delta);

void drawEditor();
bool updateEditor(float delta);

std::string openDialog(const char *file_exts);
std::string saveDialog(const char *file_exts);

void loadMap(const char *filename);
void saveMap(const char *filename);

void drawGame();
bool updateGame(float delta, bool processinput = true);
void restartLevel();
void freeGameResources();

void addShape(Vector pos, int type, int size);

// ----------------------
// Game shapes

extern SoundSystem *sound;

// d from corner to corner
const float MAX_D = 1300;

enum
{
	TYPE_TRIANGLE,
	TYPE_RECTANGLE,
	TYPE_PENTAGON,
	TYPE_HEXAGON,
	TYPE_HEPTAGON,
	TYPE_OCTAGON,
	TYPE_NONAGON,
	TYPE_DECADON,
	TYPE_COUNT
};

class Line
{
public:
	Vector start, end;
	Vector dir;

	Line()
	{
		start = Vector();
		end = Vector();
		dir = Vector();
	}

	bool lineIntersection(Line *l);
};

class Shape
{
public:	

	Line *lines;
	int type;
	Vector pos;
	Vector origpos;
	
	bool showLines;
	bool exploding;
	float explosiondistance;
	float explosiontimer;
	int size;
	float angle;
	float anglespeed;

	Shape() {};
	void updateLines();
	void init(Vector p, int t, int s)
	{
		pos = p;
		origpos = pos;
		showLines = false;
		type = t;
		size = s;
		exploding = false;
		anglespeed = 0.001f;

		explosiondistance = 0;
		explosiontimer = 0;
		lines = new Line[3+type];
		angle = rand()%1000 * 0.002f * 3.1415926f;
		explosiondistance = 0.0f;
		update(0, 0);
	}

	~Shape()
	{
		if(lines!=0) delete [] lines;
	}

	bool collisionTestRequired(Shape *s)
	{
		if(exploding && s->exploding) return false;
		return exploding || s->exploding;
	}

	bool testCollision(Shape *s)
	{
		// TODO: Collision box check first
		int i,j;
		for(i=0; i<3+type; i++)
		for(j=0; j<3+s->type; j++)
			if(lines[i].lineIntersection(&s->lines[j]))
				return true;

		return false;
	}

	bool mouseTest(int x, int y)
	{
		int dx = pos.x - x;
		int dy = pos.y - y;
		return (dx*dx+dy*dy < size*size);
	}

	void draw();
	void update(int delta, int n);

	void drawAimHelper()
	{
	
		if(!showLines || exploding
					  ) return;

		float mod = 1;
		//float mod = 1- min(explosiontimer, 4)/4.0f;
		//mod = mod*mod*mod;
			
		const float len = 1500 * mod;
		int n;
		for(n=0; n<3+type; n++)
		{
			
					glBlendFunc(GL_ONE,GL_ZERO);
					glColor4f(0.0295f, 0.0295f, 0.02295f, mod);
					glBegin(GL_QUADS);
					glVertex2f(lines[n].start.x, lines[n].start.y);
						glVertex2f(lines[n].start.x+lines[n].dir.x * len, lines[n].start.y+lines[n].dir.y * len);
						glVertex2f(lines[n].end.x+lines[n].dir.x * len, lines[n].end.y+lines[n].dir.y * len);
						glVertex2f(lines[n].end.x, lines[n].end.y);
					glEnd();
					glColor3f(1,1,1);

					glLineWidth(1);
					glColor4f(0.2f, 0.2f, 0.4f, mod);
					glBegin(GL_LINES);
					glVertex2f(lines[n].start.x, lines[n].start.y);
						glVertex2f(lines[n].start.x+lines[n].dir.x * len, lines[n].start.y+lines[n].dir.y * len);

						glVertex2f(lines[n].end.x+lines[n].dir.x * len, lines[n].end.y+lines[n].dir.y * len);
						glVertex2f(lines[n].end.x, lines[n].end.y);
					glEnd();
					glBlendFunc(GL_SRC_ALPHA, GL_ONE);
					glLineWidth(3);
				
		}
		draw();
	}

};




// -----------------------
// Util
float randFloat();
void drawBackground();
void drawBackground2();
int findSelecterShape();

// -----------------------
// Particle system
void freeParticles();
void initParticles();
void killParticles();
void updateParticles(int deltatime);
void drawParticles();
void addParticle(int type, Vector pos);
void addParticlesOnLine(Vector a, Vector b, int n);
void addParticlesOnLine2(Vector a, Vector b, int n);
void addParticlesOnLine3(Vector a, Vector b, int n);

enum
{
	PARTICLE_FLARE,
	PARTICLE_FLARE_CHAIN,
	PARTICLE_FLARE_CHAIN_3,

};

class Particle
{
public:

	float killtime;
	float time;
	bool alive;
	int type;
	Vector pos;
	Vector spd;
	int size;

	void init(int t, Vector p);
	void draw();
	void update(int deltatime);
};

#endif