#include "common.h"
void setup_sdl(const char* title, int width, int height, int bpp, bool fullscreen)
{
    if ( SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO) < 0 ) 
	{
        printf("Couldn't initialize SDL: %s\n", SDL_GetError());
        exit(1);
    }
    atexit(SDL_Quit);

	SDL_Surface *icon;
	icon = SDL_LoadBMP("data/icon.bmp");
	if(icon) SDL_WM_SetIcon(icon, NULL);
	else printf("  Failed to load icon.bmp\n");
	SDL_FreeSurface(icon);

	setup_window(title,width,height,bpp,fullscreen);
}
void setup_window(const char* title, int width, int height, int bpp, bool fullscreen) 
{

    const SDL_VideoInfo* video;

    video = SDL_GetVideoInfo( );

    if( !video ) 
	{
        printf("Couldn't get video information: %s\n", SDL_GetError());
        exit(1);
    }

    // Set the minimum requirements for the OpenGL window 
    SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 8 );
    SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 8 );
    SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 8 );

	SDL_GL_SetAttribute( SDL_GL_ALPHA_SIZE , 8);
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );

    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
				
	SDL_WM_SetCaption(title, "icon");
	
	int flags = 0;
	flags = SDL_OPENGL;
	if(fullscreen) 
		flags = SDL_OPENGL | SDL_FULLSCREEN;

	// no vsync 
	SDL_GL_SetAttribute(SDL_GL_SWAP_CONTROL, 0);
	
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

	if( SDL_SetVideoMode( width, height, video->vfmt->BitsPerPixel, flags) == NULL ) {
		printf("Couldn't set video mode: %s\n", SDL_GetError());
	}

}

void setup_gl(int width, int height)
{
    float aspect = (float)width/ (float)height;

    glViewport(0,0, width*1.0f, height*1.0f);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    
    gluPerspective(60.0f, aspect, 10.0f, 1500.0f);

    glMatrixMode(GL_MODELVIEW);

    glClearColor(1.0f, 1.0f, 1.0f, 0);
    
	glDepthFunc(GL_ALWAYS);
	glDisable(GL_DEPTH_TEST);
    glDisable(GL_CULL_FACE);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
	glEnable(GL_LINE_SMOOTH);
	glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
	glEnable(GL_POINT_SMOOTH);
	glLineWidth(2);
}

// --------

int fontBase;
int fontBase_;

void font_init()
{
  HFONT fontObject;
  fontObject  = CreateFont(14, 7, 0, 0,
                           FW_BOLD, // weight
						   false, // italic
						   false, // underline
						   false, // strike
                           ANSI_CHARSET,
						   OUT_TT_PRECIS,
                           CLIP_DEFAULT_PRECIS, 
						   ANTIALIASED_QUALITY,
                           FF_DONTCARE|DEFAULT_PITCH,
                           "Tahoma MS");
  
  fontBase = glGenLists(96);

  SelectObject(wglGetCurrentDC(), fontObject);
  wglUseFontBitmaps(wglGetCurrentDC(), 32, 96, fontBase);

  DeleteObject(fontObject);

  fontObject  = CreateFont(12, 6, 0, 0,
                           FW_NORMAL, // weight
						   false, // italic
						   false, // underline
						   false, // strike
                           ANSI_CHARSET,
						   OUT_TT_PRECIS,
                           CLIP_DEFAULT_PRECIS, 
						   ANTIALIASED_QUALITY,
                           FF_DONTCARE|DEFAULT_PITCH,
                           "Tahoma MS");
  
  
  fontBase_ = glGenLists(96);
  SelectObject(wglGetCurrentDC(), fontObject);
  wglUseFontBitmaps(wglGetCurrentDC(), 32, 96, fontBase_);

  DeleteObject(fontObject);

}

int getFontW(const char *str)
{
    glColorMask(false, false, false, false);
    glRasterPos2i(0,0);
    glPushAttrib(GL_LIST_BIT);
		glListBase(fontBase - 32);
		glCallLists(strlen(str), GL_UNSIGNED_BYTE, str);
    glPopAttrib();
	int rasterPosition[4];
    glGetIntegerv(GL_CURRENT_RASTER_POSITION, rasterPosition);
    glColorMask(true, true, true, true);

	return rasterPosition[0];
}

void print(const char *str, int x, int y) 
{
  glRasterPos2i(x, y);
  glPushAttrib(GL_LIST_BIT);
	glListBase(fontBase - 32);
	glCallLists(int(strlen(str)), GL_UNSIGNED_BYTE, str);
  glPopAttrib();
}

void printCenteredX(const char *str, int x, int y)
{
	int w_ = getFontW(str);
	print(str, x - w_/2, y);
}


void printSmall(const char *str, int x, int y) 
{
  glRasterPos2i(x, y);
  glPushAttrib(GL_LIST_BIT);
	glListBase(fontBase_ - 32);
	glCallLists(int(strlen(str)), GL_UNSIGNED_BYTE, str);
  glPopAttrib();
}

void perspective2D(float width, float height)
{
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();	
	glOrtho(0, width, height, 0,-1,1);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix(); 
	glLoadIdentity();
}
void perspective3D()
{
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}


void drawSprite(RRect to, Texture *t, GLfloat rotation, GLfloat scale) 
{

	glPushMatrix();

		glBlendFunc(GL_ONE,GL_ONE);
		glEnable(GL_BLEND);

		float move_left	= to.w*0.5f;
		float move_top	= to.h*0.5f;

		glTranslatef((float)to.x+move_left, (float)to.y+move_top, 0);
		glScalef(scale,scale,scale);
		
		
		glRotatef(rotation,0,0,1);

		float from_x, from_y, from_x2, from_y2;
		from_x  = 0;
		from_y  = 0;
		from_x2 = 1;
		from_y2 = 1;

		glBindTexture(GL_TEXTURE_2D, t->id);

        glBegin(GL_QUADS);
			 glTexCoord2f(from_x2, from_y2);
			 glVertex3f(move_left, move_top,  0);
			 glTexCoord2f(from_x, from_y2);
			 glVertex3f(-move_left,move_top,  0);
			 glTexCoord2f(from_x, from_y);
			 glVertex3f(-move_left,-move_top, 0);
			 glTexCoord2f(from_x2, from_y);
			 glVertex3f(move_left, -move_top, 0);

        glEnd();

	glPopMatrix();
}
bool load_texture(char *filename, Texture *m) 
{

		SDL_Surface *surface;
		int mode;

		surface = IMG_Load(filename);
    		if (!surface) {
				printf("Warning! Unable to load %s\n", filename);
				return 0;
		}

		if (surface->format->BytesPerPixel == 3) 
		{ 
				mode = GL_RGB;
				printf("Loaded %s as RGB\n", filename);
		} 
		else if (surface->format->BytesPerPixel == 4) 
		{ 
				mode = GL_RGBA;
				printf("Loaded %s as RGBA\n", filename);
		} 
		else 
		{
				SDL_FreeSurface(surface);
				printf("Warning! Unknown BPP %s\n", filename);
				return 0;
		}

		glGenTextures(1, &(m->id));
		glBindTexture(GL_TEXTURE_2D, m->id);
		gluBuild2DMipmaps(GL_TEXTURE_2D, 4, surface->w, surface->h, mode, GL_UNSIGNED_BYTE, surface->pixels);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

		// Store the variables for fast use later on
		m->width = surface->w;
		m->height = surface->h;
		SDL_FreeSurface(surface);
		return true;
}